module resize

// example program to resizing controls

import StdEnv, StdIO

Start :: *World -> *World
Start world
	=	startIO 0 0 [initialise] [] world
where
	initialise ps
			= snd (openWindow 0 wdef ps)
	wdef	= Window "Window" compound
				[	WindowClose	(noLS closeProcess)
				,	WindowResize
				,	WindowHMargin 0 0
				,	WindowVMargin 0 0
				,	WindowItemSpace 0 0
				]
	compound= CompoundControl
				(ListLS [custom,custom,custom])
				[	ControlResize compoundresize
				,	ControlSize	csize
				,	ControlHMargin 0 0
				,	ControlVMargin 0 0
				,	ControlItemSpace 0 0
				,	ControlLook (\_ {newFrame}->[draw newFrame])
				]
	compoundresize _ _ newwsize
			= {newwsize & w=newwsize.w/3*3}
	csize	= {w=210,h=210}
	custom	= CustomControl {w=csize.w/3,h=20} look [ControlResize resize]
	resize curcsize oldwsize {w}
			//= {curcsize & w=w}
			= {curcsize & w=w/3}
	look _ {newFrame}
			= [	draw newFrame
			  ,	drawLine newFrame.corner1 newFrame.corner2
			  ,	drawLine {newFrame.corner1 & y=newFrame.corner2.y} {newFrame.corner2 & y=newFrame.corner1.y}
			  ]

